/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import filenet.vw.base.logging.Logger;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSType;
import javax.xml.namespace.QName;
import org.apache.axis.wsdl.symbolTable.ContainedAttribute;

public class WSAttribute {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    private static String m_className = "WSAttribute";
    private WSDefinition m_definition = null;
    private ContainedAttribute m_attrib = null;
    private WSType m_type = null;
    private QName m_qName = null;

    public static String _get_FILE_DATE() {
        return "$Date:   15 Oct 2008 18:53:58  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.6  $";
    }

    public void releaseReferences() {
        block3: {
            try {
                this.m_definition = null;
                this.m_attrib = null;
                WSType type = this.m_type;
                this.m_type = null;
                if (type != null) {
                    type.releaseReferences();
                    type = null;
                }
                this.m_qName = null;
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block3;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public WSAttribute(WSDefinition definition, ContainedAttribute attrib) {
        this.m_definition = definition;
        this.m_attrib = attrib;
        if (attrib != null) {
            this.m_type = this.m_definition.getType(attrib.getType());
            this.m_qName = attrib.getQName();
        }
    }

    public String getName() {
        if (this.m_qName != null) {
            String name = this.m_qName.getLocalPart();
            if (name != null) {
                name = name.substring(name.lastIndexOf(">"));
            }
            return name;
        }
        return null;
    }

    public QName getQName() {
        return this.m_qName;
    }

    public String getDisplayName() {
        if (this.m_qName != null) {
            return this.m_qName.getLocalPart();
        }
        return null;
    }

    public WSType getType() {
        return this.m_type;
    }

    public String getNamespace() {
        if (this.m_qName != null) {
            return this.m_qName.getNamespaceURI();
        }
        return null;
    }

    public String getNamespacePrefix() {
        String namespace = this.getNamespace();
        if (namespace != null && namespace.length() > 0 && this.m_definition != null) {
            return this.m_definition.getNamespacePrefix(namespace);
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    WSDefinition getDefinition() {
        return this.m_definition;
    }
}

